// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range Border Request.
 */
public class BaseWorkbookRangeBorderRequest extends BaseRequest implements IBaseWorkbookRangeBorderRequest {

    /**
     * The request for the WorkbookRangeBorder
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookRangeBorderRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookRangeBorder from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookRangeBorder> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookRangeBorder from the service
     * @return The WorkbookRangeBorder from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeBorder get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookRangeBorder with a source
     * @param sourceWorkbookRangeBorder The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookRangeBorder sourceWorkbookRangeBorder, final ICallback<WorkbookRangeBorder> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookRangeBorder);
    }

    /**
     * Patches this WorkbookRangeBorder with a source
     * @param sourceWorkbookRangeBorder The source object with updates
     * @return The updated WorkbookRangeBorder
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeBorder patch(final WorkbookRangeBorder sourceWorkbookRangeBorder) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRangeBorder);
    }

    /**
     * Creates a WorkbookRangeBorder with a new object
     * @param newWorkbookRangeBorder The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookRangeBorder newWorkbookRangeBorder, final ICallback<WorkbookRangeBorder> callback) {
        send(HttpMethod.POST, callback, newWorkbookRangeBorder);
    }

    /**
     * Creates a WorkbookRangeBorder with a new object
     * @param newWorkbookRangeBorder The new object to create
     * @return The created WorkbookRangeBorder
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeBorder post(final WorkbookRangeBorder newWorkbookRangeBorder) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRangeBorder);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookRangeBorderRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookRangeBorderRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookRangeBorderRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookRangeBorderRequest)this;
     }

}
