// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Gamma_Inv Request Builder.
 */
public class BaseWorkbookFunctionsGamma_InvRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsGamma_Inv
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsGamma_InvRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement probability, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("probability", probability);
        mBodyParams.put("alpha", alpha);
        mBodyParams.put("beta", beta);
    }

    /**
     * Creates the IWorkbookFunctionsGamma_InvRequest
     *
     * @return The IWorkbookFunctionsGamma_InvRequest instance
     */
    public IWorkbookFunctionsGamma_InvRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsGamma_InvRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsGamma_InvRequest instance
     */
    public IWorkbookFunctionsGamma_InvRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsGamma_InvRequest request = new WorkbookFunctionsGamma_InvRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("probability")) {
            request.mBody.probability = getParameter("probability");
        }

        if (hasParameter("alpha")) {
            request.mBody.alpha = getParameter("alpha");
        }

        if (hasParameter("beta")) {
            request.mBody.beta = getParameter("beta");
        }

        return request;
    }
}
