// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Point Request.
 */
public class BaseWorkbookChartPointRequest extends BaseRequest implements IBaseWorkbookChartPointRequest {

    /**
     * The request for the WorkbookChartPoint
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookChartPointRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookChartPoint from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChartPoint> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartPoint from the service
     * @return The WorkbookChartPoint from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartPoint get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookChartPoint with a source
     * @param sourceWorkbookChartPoint The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookChartPoint sourceWorkbookChartPoint, final ICallback<WorkbookChartPoint> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartPoint);
    }

    /**
     * Patches this WorkbookChartPoint with a source
     * @param sourceWorkbookChartPoint The source object with updates
     * @return The updated WorkbookChartPoint
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartPoint patch(final WorkbookChartPoint sourceWorkbookChartPoint) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartPoint);
    }

    /**
     * Creates a WorkbookChartPoint with a new object
     * @param newWorkbookChartPoint The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookChartPoint newWorkbookChartPoint, final ICallback<WorkbookChartPoint> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartPoint);
    }

    /**
     * Creates a WorkbookChartPoint with a new object
     * @param newWorkbookChartPoint The new object to create
     * @return The created WorkbookChartPoint
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartPoint post(final WorkbookChartPoint newWorkbookChartPoint) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartPoint);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookChartPointRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookChartPointRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookChartPointRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookChartPointRequest)this;
     }

}
