// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base User Delta Collection Request.
 */
public class BaseUserDeltaCollectionRequest extends BaseCollectionRequest<BaseUserDeltaCollectionResponse, IUserDeltaCollectionPage> implements IBaseUserDeltaCollectionRequest {


    /**
     * The request for this UserDelta
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseUserDeltaCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseUserDeltaCollectionResponse.class, IUserDeltaCollectionPage.class);
    }


    public void get(final ICallback<IUserDeltaCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IUserDeltaCollectionPage get() throws ClientException {
        final BaseUserDeltaCollectionResponse response = send();
        return buildFromResponse(response);
    }


    public IUserDeltaCollectionPage buildFromResponse(final BaseUserDeltaCollectionResponse response) {
        final IUserDeltaCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new UserDeltaCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final IUserDeltaCollectionPage page = new UserDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IUserDeltaCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (IUserDeltaCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IUserDeltaCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value+""));
        return (IUserDeltaCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IUserDeltaCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (IUserDeltaCollectionRequest)this;
    }

}
