// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Domain Dns Srv Record.
 */
public class BaseDomainDnsSrvRecord extends DomainDnsRecord implements IJsonBackedObject {


    public BaseDomainDnsSrvRecord() {
        oDataType = "microsoft.graph.domainDnsSrvRecord";
    }

    /**
     * The Name Target.
	 * Value to use when configuring the Target property of the SRV record at the DNS host.
     */
    @SerializedName("nameTarget")
    @Expose
    public String nameTarget;

    /**
     * The Port.
	 * Value to use when configuring the port property of the SRV record at the DNS host.
     */
    @SerializedName("port")
    @Expose
    public Integer port;

    /**
     * The Priority.
	 * Value to use when configuring the priority property of the SRV record at the DNS host.
     */
    @SerializedName("priority")
    @Expose
    public Integer priority;

    /**
     * The Protocol.
	 * Value to use when configuring the protocol property of the SRV record at the DNS host.
     */
    @SerializedName("protocol")
    @Expose
    public String protocol;

    /**
     * The Service.
	 * Value to use when configuring the service property of the SRV record at the DNS host.
     */
    @SerializedName("service")
    @Expose
    public String service;

    /**
     * The Weight.
	 * Value to use when configuring the weight property of the SRV record at the DNS host.
     */
    @SerializedName("weight")
    @Expose
    public Integer weight;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
