/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.GsonFactory;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Map;

public class DefaultSerializer
implements ISerializer {
    private final Gson mGson;
    private final ILogger mLogger;

    public DefaultSerializer(ILogger logger) {
        this.mLogger = logger;
        this.mGson = GsonFactory.getGsonInstance(logger);
    }

    @Override
    public <T> T deserializeObject(String inputString, Class<T> clazz) {
        Object jsonObject = this.mGson.fromJson(inputString, clazz);
        if (jsonObject instanceof IJsonBackedObject) {
            this.mLogger.logDebug("Deserializing type " + clazz.getSimpleName());
            IJsonBackedObject jsonBackedObject = (IJsonBackedObject)jsonObject;
            JsonObject rawObject = (JsonObject)this.mGson.fromJson(inputString, JsonObject.class);
            jsonBackedObject.setRawObject(this, rawObject);
            jsonBackedObject.getAdditionalDataManager().setAdditionalData(rawObject);
        } else {
            this.mLogger.logDebug("Deserializing a non-IJsonBackedObject type " + clazz.getSimpleName());
        }
        return (T)jsonObject;
    }

    @Override
    public <T> String serializeObject(T serializableObject) {
        this.mLogger.logDebug("Serializing type " + serializableObject.getClass().getSimpleName());
        JsonElement outJsonTree = this.mGson.toJsonTree(serializableObject);
        if (serializableObject instanceof IJsonBackedObject) {
            AdditionalDataManager additionalData = ((IJsonBackedObject)serializableObject).getAdditionalDataManager();
            if (outJsonTree.isJsonObject()) {
                JsonObject outJson = outJsonTree.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : additionalData.entrySet()) {
                    if (this.fieldIsOdataTransient(entry)) continue;
                    outJson.add(entry.getKey(), entry.getValue());
                }
                outJsonTree = outJson;
            }
        }
        return outJsonTree.toString();
    }

    private boolean fieldIsOdataTransient(Map.Entry<String, JsonElement> entry) {
        return entry.getKey().startsWith("@");
    }
}

