/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.extensions.BaseItem;
import com.microsoft.graph.extensions.DriveItem;
import com.microsoft.graph.extensions.DriveItemCollectionPage;
import com.microsoft.graph.extensions.IdentitySet;
import com.microsoft.graph.extensions.Site;
import com.microsoft.graph.generated.BaseDriveItemCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class BaseSharedDriveItem
extends BaseItem
implements IJsonBackedObject {
    @SerializedName(value="name")
    @Expose
    public String name;
    @SerializedName(value="owner")
    @Expose
    public IdentitySet owner;
    @SerializedName(value="driveItem")
    @Expose
    public DriveItem driveItem;
    public transient DriveItemCollectionPage items;
    @SerializedName(value="root")
    @Expose
    public DriveItem root;
    @SerializedName(value="site")
    @Expose
    public Site site;
    private transient JsonObject mRawObject;
    private transient ISerializer mSerializer;

    public BaseSharedDriveItem() {
        this.oDataType = "microsoft.graph.sharedDriveItem";
    }

    @Override
    public JsonObject getRawObject() {
        return this.mRawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.mSerializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.mSerializer = serializer;
        this.mRawObject = json;
        if (json.has("items")) {
            BaseDriveItemCollectionResponse response = new BaseDriveItemCollectionResponse();
            if (json.has("items@odata.nextLink")) {
                response.nextLink = json.get("items@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("items").toString(), JsonObject[].class);
            DriveItem[] array = new DriveItem[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DriveItem.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.items = new DriveItemCollectionPage(response, null);
        }
    }
}

