/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IInferenceClassificationOverrideCollectionPage;
import com.microsoft.graph.extensions.IInferenceClassificationOverrideCollectionRequest;
import com.microsoft.graph.extensions.InferenceClassificationOverride;
import com.microsoft.graph.extensions.InferenceClassificationOverrideCollectionPage;
import com.microsoft.graph.extensions.InferenceClassificationOverrideCollectionRequest;
import com.microsoft.graph.extensions.InferenceClassificationOverrideCollectionRequestBuilder;
import com.microsoft.graph.extensions.InferenceClassificationOverrideRequestBuilder;
import com.microsoft.graph.generated.BaseInferenceClassificationOverrideCollectionResponse;
import com.microsoft.graph.generated.IBaseInferenceClassificationOverrideCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseInferenceClassificationOverrideCollectionRequest
extends BaseCollectionRequest<BaseInferenceClassificationOverrideCollectionResponse, IInferenceClassificationOverrideCollectionPage>
implements IBaseInferenceClassificationOverrideCollectionRequest {
    public BaseInferenceClassificationOverrideCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseInferenceClassificationOverrideCollectionResponse.class, IInferenceClassificationOverrideCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IInferenceClassificationOverrideCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseInferenceClassificationOverrideCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IInferenceClassificationOverrideCollectionPage get() throws ClientException {
        BaseInferenceClassificationOverrideCollectionResponse response = (BaseInferenceClassificationOverrideCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(InferenceClassificationOverride newInferenceClassificationOverride, ICallback<InferenceClassificationOverride> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new InferenceClassificationOverrideRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newInferenceClassificationOverride, callback);
    }

    @Override
    public InferenceClassificationOverride post(InferenceClassificationOverride newInferenceClassificationOverride) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new InferenceClassificationOverrideRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newInferenceClassificationOverride);
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (InferenceClassificationOverrideCollectionRequest)this;
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (InferenceClassificationOverrideCollectionRequest)this;
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (InferenceClassificationOverrideCollectionRequest)this;
    }

    public IInferenceClassificationOverrideCollectionPage buildFromResponse(BaseInferenceClassificationOverrideCollectionResponse response) {
        InferenceClassificationOverrideCollectionRequestBuilder builder = response.nextLink != null ? new InferenceClassificationOverrideCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        InferenceClassificationOverrideCollectionPage page = new InferenceClassificationOverrideCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

