// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Trim Mean Request Builder.
 */
public class BaseWorkbookFunctionsTrimMeanRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsTrimMean
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsTrimMeanRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement array, final com.google.gson.JsonElement percent) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("array", array);
        mBodyParams.put("percent", percent);
    }

    /**
     * Creates the IWorkbookFunctionsTrimMeanRequest
     *
     * @return The IWorkbookFunctionsTrimMeanRequest instance
     */
    public IWorkbookFunctionsTrimMeanRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsTrimMeanRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsTrimMeanRequest instance
     */
    public IWorkbookFunctionsTrimMeanRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsTrimMeanRequest request = new WorkbookFunctionsTrimMeanRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("array")) {
            request.mBody.array = getParameter("array");
        }

        if (hasParameter("percent")) {
            request.mBody.percent = getParameter("percent");
        }

        return request;
    }
}
