// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Accr Int Request Builder.
 */
public class BaseWorkbookFunctionsAccrIntRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsAccrInt
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsAccrIntRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement firstInterest, final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement par, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis, final com.google.gson.JsonElement calcMethod) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("issue", issue);
        mBodyParams.put("firstInterest", firstInterest);
        mBodyParams.put("settlement", settlement);
        mBodyParams.put("rate", rate);
        mBodyParams.put("par", par);
        mBodyParams.put("frequency", frequency);
        mBodyParams.put("basis", basis);
        mBodyParams.put("calcMethod", calcMethod);
    }

    /**
     * Creates the IWorkbookFunctionsAccrIntRequest
     *
     * @return The IWorkbookFunctionsAccrIntRequest instance
     */
    public IWorkbookFunctionsAccrIntRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsAccrIntRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsAccrIntRequest instance
     */
    public IWorkbookFunctionsAccrIntRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsAccrIntRequest request = new WorkbookFunctionsAccrIntRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("issue")) {
            request.mBody.issue = getParameter("issue");
        }

        if (hasParameter("firstInterest")) {
            request.mBody.firstInterest = getParameter("firstInterest");
        }

        if (hasParameter("settlement")) {
            request.mBody.settlement = getParameter("settlement");
        }

        if (hasParameter("rate")) {
            request.mBody.rate = getParameter("rate");
        }

        if (hasParameter("par")) {
            request.mBody.par = getParameter("par");
        }

        if (hasParameter("frequency")) {
            request.mBody.frequency = getParameter("frequency");
        }

        if (hasParameter("basis")) {
            request.mBody.basis = getParameter("basis");
        }

        if (hasParameter("calcMethod")) {
            request.mBody.calcMethod = getParameter("calcMethod");
        }

        return request;
    }
}
