/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IConnection;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.HeaderOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.HashMap;
import java.util.Map;

public class UrlConnection
implements IConnection {
    private final HttpURLConnection mConnection;
    private HashMap<String, String> mHeaders;

    public UrlConnection(IHttpRequest request) throws IOException {
        this.mConnection = (HttpURLConnection)request.getRequestUrl().openConnection();
        for (HeaderOption header : request.getHeaders()) {
            this.mConnection.addRequestProperty(header.getName(), header.getValue());
        }
        this.mConnection.setUseCaches(request.getUseCaches());
        try {
            this.mConnection.setRequestMethod(request.getHttpMethod().toString());
        }
        catch (ProtocolException ignored) {
            this.mConnection.setRequestMethod(HttpMethod.POST.toString());
            this.mConnection.addRequestProperty("X-HTTP-Method-Override", request.getHttpMethod().toString());
            this.mConnection.addRequestProperty("X-HTTP-Method", request.getHttpMethod().toString());
        }
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        this.mConnection.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void addRequestHeader(String headerName, String headerValue) {
        this.mConnection.addRequestProperty(headerName, headerValue);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.mConnection.setDoOutput(true);
        return this.mConnection.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        int httpClientErrorResponseCode = 400;
        if (this.mConnection.getResponseCode() >= 400) {
            return this.mConnection.getErrorStream();
        }
        return this.mConnection.getInputStream();
    }

    @Override
    public int getContentLength() {
        return this.mConnection.getContentLength();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.mConnection.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.mConnection.getResponseMessage();
    }

    @Override
    public void close() {
        this.mConnection.disconnect();
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.mHeaders == null) {
            this.mHeaders = UrlConnection.getResponseHeaders(this.mConnection);
        }
        return this.mHeaders;
    }

    @Override
    public String getRequestMethod() {
        return this.mConnection.getRequestMethod();
    }

    @Override
    public void setContentLength(int length) {
        this.mConnection.setFixedLengthStreamingMode(length);
    }

    private static HashMap<String, String> getResponseHeaders(HttpURLConnection connection) {
        HashMap<String, String> headers = new HashMap<String, String>();
        int index = 0;
        while (true) {
            String headerName = connection.getHeaderFieldKey(index);
            String headerValue = connection.getHeaderField(index);
            if (headerName == null && headerValue == null) break;
            headers.put(headerName, headerValue);
            ++index;
        }
        return headers;
    }
}

