/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IInvitationCollectionPage;
import com.microsoft.graph.extensions.IInvitationCollectionRequest;
import com.microsoft.graph.extensions.Invitation;
import com.microsoft.graph.extensions.InvitationCollectionPage;
import com.microsoft.graph.extensions.InvitationCollectionRequest;
import com.microsoft.graph.extensions.InvitationCollectionRequestBuilder;
import com.microsoft.graph.extensions.InvitationRequestBuilder;
import com.microsoft.graph.generated.BaseInvitationCollectionResponse;
import com.microsoft.graph.generated.IBaseInvitationCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseInvitationCollectionRequest
extends BaseCollectionRequest<BaseInvitationCollectionResponse, IInvitationCollectionPage>
implements IBaseInvitationCollectionRequest {
    public BaseInvitationCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseInvitationCollectionResponse.class, IInvitationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IInvitationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseInvitationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IInvitationCollectionPage get() throws ClientException {
        BaseInvitationCollectionResponse response = (BaseInvitationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Invitation newInvitation, ICallback<Invitation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new InvitationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newInvitation, callback);
    }

    @Override
    public Invitation post(Invitation newInvitation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new InvitationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newInvitation);
    }

    @Override
    public IInvitationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (InvitationCollectionRequest)this;
    }

    @Override
    public IInvitationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (InvitationCollectionRequest)this;
    }

    @Override
    public IInvitationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (InvitationCollectionRequest)this;
    }

    public IInvitationCollectionPage buildFromResponse(BaseInvitationCollectionResponse response) {
        InvitationCollectionRequestBuilder builder = response.nextLink != null ? new InvitationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        InvitationCollectionPage page = new InvitationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

