/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DriveSharedWithMeCollectionPage;
import com.microsoft.graph.extensions.DriveSharedWithMeCollectionRequestBuilder;
import com.microsoft.graph.extensions.IDriveSharedWithMeCollectionPage;
import com.microsoft.graph.extensions.IDriveSharedWithMeCollectionRequest;
import com.microsoft.graph.generated.BaseDriveSharedWithMeCollectionResponse;
import com.microsoft.graph.generated.IBaseDriveSharedWithMeCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDriveSharedWithMeCollectionRequest
extends BaseCollectionRequest<BaseDriveSharedWithMeCollectionResponse, IDriveSharedWithMeCollectionPage>
implements IBaseDriveSharedWithMeCollectionRequest {
    public BaseDriveSharedWithMeCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDriveSharedWithMeCollectionResponse.class, IDriveSharedWithMeCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveSharedWithMeCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveSharedWithMeCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveSharedWithMeCollectionPage get() throws ClientException {
        BaseDriveSharedWithMeCollectionResponse response = (BaseDriveSharedWithMeCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveSharedWithMeCollectionPage buildFromResponse(BaseDriveSharedWithMeCollectionResponse response) {
        DriveSharedWithMeCollectionRequestBuilder builder = response.nextLink != null ? new DriveSharedWithMeCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveSharedWithMeCollectionPage page = new DriveSharedWithMeCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveSharedWithMeCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDriveSharedWithMeCollectionRequest)((Object)this);
    }

    @Override
    public IDriveSharedWithMeCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDriveSharedWithMeCollectionRequest)((Object)this);
    }

    @Override
    public IDriveSharedWithMeCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDriveSharedWithMeCollectionRequest)((Object)this);
    }
}

