// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Z_Test Request Builder.
 */
public class BaseWorkbookFunctionsZ_TestRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsZ_Test
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsZ_TestRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement array, final com.google.gson.JsonElement x, final com.google.gson.JsonElement sigma) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("array", array);
        mBodyParams.put("x", x);
        mBodyParams.put("sigma", sigma);
    }

    /**
     * Creates the IWorkbookFunctionsZ_TestRequest
     *
     * @return The IWorkbookFunctionsZ_TestRequest instance
     */
    public IWorkbookFunctionsZ_TestRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsZ_TestRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsZ_TestRequest instance
     */
    public IWorkbookFunctionsZ_TestRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsZ_TestRequest request = new WorkbookFunctionsZ_TestRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("array")) {
            request.mBody.array = getParameter("array");
        }

        if (hasParameter("x")) {
            request.mBody.x = getParameter("x");
        }

        if (hasParameter("sigma")) {
            request.mBody.sigma = getParameter("sigma");
        }

        return request;
    }
}
