// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base User Find Meeting Times Request Builder.
 */
public class BaseUserFindMeetingTimesRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this UserFindMeetingTimes
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseUserFindMeetingTimesRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final java.util.List<AttendeeBase> attendees, final LocationConstraint locationConstraint, final TimeConstraint timeConstraint, final javax.xml.datatype.Duration meetingDuration, final Integer maxCandidates, final Boolean isOrganizerOptional, final Boolean returnSuggestionReasons, final Double minimumAttendeePercentage) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("attendees", attendees);
        mBodyParams.put("locationConstraint", locationConstraint);
        mBodyParams.put("timeConstraint", timeConstraint);
        mBodyParams.put("meetingDuration", meetingDuration);
        mBodyParams.put("maxCandidates", maxCandidates);
        mBodyParams.put("isOrganizerOptional", isOrganizerOptional);
        mBodyParams.put("returnSuggestionReasons", returnSuggestionReasons);
        mBodyParams.put("minimumAttendeePercentage", minimumAttendeePercentage);
    }

    /**
     * Creates the IUserFindMeetingTimesRequest
     *
     * @return The IUserFindMeetingTimesRequest instance
     */
    public IUserFindMeetingTimesRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IUserFindMeetingTimesRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IUserFindMeetingTimesRequest instance
     */
    public IUserFindMeetingTimesRequest buildRequest(final java.util.List<Option> requestOptions) {
        UserFindMeetingTimesRequest request = new UserFindMeetingTimesRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("attendees")) {
            request.mBody.attendees = getParameter("attendees");
        }

        if (hasParameter("locationConstraint")) {
            request.mBody.locationConstraint = getParameter("locationConstraint");
        }

        if (hasParameter("timeConstraint")) {
            request.mBody.timeConstraint = getParameter("timeConstraint");
        }

        if (hasParameter("meetingDuration")) {
            request.mBody.meetingDuration = getParameter("meetingDuration");
        }

        if (hasParameter("maxCandidates")) {
            request.mBody.maxCandidates = getParameter("maxCandidates");
        }

        if (hasParameter("isOrganizerOptional")) {
            request.mBody.isOrganizerOptional = getParameter("isOrganizerOptional");
        }

        if (hasParameter("returnSuggestionReasons")) {
            request.mBody.returnSuggestionReasons = getParameter("returnSuggestionReasons");
        }

        if (hasParameter("minimumAttendeePercentage")) {
            request.mBody.minimumAttendeePercentage = getParameter("minimumAttendeePercentage");
        }

        return request;
    }
}
