/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.gson.JsonObject;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Collections;
import java.util.List;

public abstract class BaseCollectionPage<T1, T2 extends IRequestBuilder>
implements IBaseCollectionPage<T1, T2> {
    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);
    private final List<T1> mPageContents;
    private final T2 mRequestBuilder;
    private transient JsonObject mRawObject;
    private transient ISerializer mSerializer;

    public BaseCollectionPage(List<T1> pageContents, T2 nextRequestBuilder) {
        this.mPageContents = Collections.unmodifiableList(pageContents);
        this.mRequestBuilder = nextRequestBuilder;
    }

    @Override
    public T2 getNextPage() {
        return this.mRequestBuilder;
    }

    @Override
    public List<T1> getCurrentPage() {
        return this.mPageContents;
    }

    @Override
    public JsonObject getRawObject() {
        return this.mRawObject;
    }

    protected ISerializer getSerializer() {
        return this.mSerializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.mSerializer = serializer;
        this.mRawObject = json;
    }

    @Override
    public final AdditionalDataManager getAdditionalDataManager() {
        return this.additionalDataManager;
    }
}

