// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Shared Drive Item Request.
 */
public class BaseSharedDriveItemRequest extends BaseRequest implements IBaseSharedDriveItemRequest {

    /**
     * The request for the SharedDriveItem
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseSharedDriveItemRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the SharedDriveItem from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<SharedDriveItem> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SharedDriveItem from the service
     * @return The SharedDriveItem from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SharedDriveItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this SharedDriveItem with a source
     * @param sourceSharedDriveItem The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final SharedDriveItem sourceSharedDriveItem, final ICallback<SharedDriveItem> callback) {
        send(HttpMethod.PATCH, callback, sourceSharedDriveItem);
    }

    /**
     * Patches this SharedDriveItem with a source
     * @param sourceSharedDriveItem The source object with updates
     * @return The updated SharedDriveItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SharedDriveItem patch(final SharedDriveItem sourceSharedDriveItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceSharedDriveItem);
    }

    /**
     * Creates a SharedDriveItem with a new object
     * @param newSharedDriveItem The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final SharedDriveItem newSharedDriveItem, final ICallback<SharedDriveItem> callback) {
        send(HttpMethod.POST, callback, newSharedDriveItem);
    }

    /**
     * Creates a SharedDriveItem with a new object
     * @param newSharedDriveItem The new object to create
     * @return The created SharedDriveItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SharedDriveItem post(final SharedDriveItem newSharedDriveItem) throws ClientException {
        return send(HttpMethod.POST, newSharedDriveItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public ISharedDriveItemRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (SharedDriveItemRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public ISharedDriveItemRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (SharedDriveItemRequest)this;
     }

}
