// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Domain.
 */
public class BaseDomain extends Entity implements IJsonBackedObject {


    public BaseDomain() {
        oDataType = "microsoft.graph.domain";
    }

    /**
     * The Authentication Type.
	 * 
     */
    @SerializedName("authenticationType")
    @Expose
    public String authenticationType;

    /**
     * The Availability Status.
	 * 
     */
    @SerializedName("availabilityStatus")
    @Expose
    public String availabilityStatus;

    /**
     * The Is Admin Managed.
	 * 
     */
    @SerializedName("isAdminManaged")
    @Expose
    public Boolean isAdminManaged;

    /**
     * The Is Default.
	 * 
     */
    @SerializedName("isDefault")
    @Expose
    public Boolean isDefault;

    /**
     * The Is Initial.
	 * 
     */
    @SerializedName("isInitial")
    @Expose
    public Boolean isInitial;

    /**
     * The Is Root.
	 * 
     */
    @SerializedName("isRoot")
    @Expose
    public Boolean isRoot;

    /**
     * The Is Verified.
	 * 
     */
    @SerializedName("isVerified")
    @Expose
    public Boolean isVerified;

    /**
     * The Supported Services.
	 * 
     */
    @SerializedName("supportedServices")
    @Expose
    public java.util.List<String> supportedServices;

    /**
     * The State.
	 * 
     */
    @SerializedName("state")
    @Expose
    public DomainState state;

    /**
     * The Service Configuration Records.
	 * 
     */
    public transient DomainDnsRecordCollectionPage serviceConfigurationRecords;

    /**
     * The Verification Dns Records.
	 * 
     */
    public transient DomainDnsRecordCollectionPage verificationDnsRecords;

    /**
     * The Domain Name References.
	 * 
     */
    public transient DirectoryObjectCollectionPage domainNameReferences;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;


        if (json.has("serviceConfigurationRecords")) {
            final BaseDomainDnsRecordCollectionResponse response = new BaseDomainDnsRecordCollectionResponse();
            if (json.has("serviceConfigurationRecords@odata.nextLink")) {
                response.nextLink = json.get("serviceConfigurationRecords@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("serviceConfigurationRecords").toString(), JsonObject[].class);
            final DomainDnsRecord[] array = new DomainDnsRecord[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DomainDnsRecord.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            serviceConfigurationRecords = new DomainDnsRecordCollectionPage(response, null);
        }

        if (json.has("verificationDnsRecords")) {
            final BaseDomainDnsRecordCollectionResponse response = new BaseDomainDnsRecordCollectionResponse();
            if (json.has("verificationDnsRecords@odata.nextLink")) {
                response.nextLink = json.get("verificationDnsRecords@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("verificationDnsRecords").toString(), JsonObject[].class);
            final DomainDnsRecord[] array = new DomainDnsRecord[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DomainDnsRecord.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            verificationDnsRecords = new DomainDnsRecordCollectionPage(response, null);
        }

        if (json.has("domainNameReferences")) {
            final BaseDirectoryObjectCollectionResponse response = new BaseDirectoryObjectCollectionResponse();
            if (json.has("domainNameReferences@odata.nextLink")) {
                response.nextLink = json.get("domainNameReferences@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("domainNameReferences").toString(), JsonObject[].class);
            final DirectoryObject[] array = new DirectoryObject[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DirectoryObject.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            domainNameReferences = new DirectoryObjectCollectionPage(response, null);
        }
    }
}
