/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DirectoryObject;
import com.microsoft.graph.extensions.DirectoryObjectCollectionReferenceRequest;
import com.microsoft.graph.extensions.DirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.extensions.IDirectoryObjectCollectionPage;
import com.microsoft.graph.extensions.IDirectoryObjectCollectionReferenceRequest;
import com.microsoft.graph.generated.BaseDirectoryObjectCollectionResponse;
import com.microsoft.graph.generated.IBaseDirectoryObjectCollectionReferenceRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDirectoryObjectCollectionReferenceRequest
extends BaseCollectionRequest<BaseDirectoryObjectCollectionResponse, IDirectoryObjectCollectionPage>
implements IBaseDirectoryObjectCollectionReferenceRequest {
    public BaseDirectoryObjectCollectionReferenceRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDirectoryObjectCollectionResponse.class, IDirectoryObjectCollectionPage.class);
    }

    @Override
    public void post(DirectoryObject newDirectoryObject, ICallback<DirectoryObject> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/directoryObjects/" + newDirectoryObject.id);
        new DirectoryObjectWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newDirectoryObject, body, callback);
    }

    @Override
    public DirectoryObject post(DirectoryObject newDirectoryObject) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/directoryObjects/" + newDirectoryObject.id);
        return new DirectoryObjectWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newDirectoryObject, body);
    }

    public IDirectoryObjectCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DirectoryObjectCollectionReferenceRequest)this;
    }

    @Override
    public IDirectoryObjectCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DirectoryObjectCollectionReferenceRequest)this;
    }

    @Override
    public IDirectoryObjectCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DirectoryObjectCollectionReferenceRequest)this;
    }
}

