/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Attachment;
import com.microsoft.graph.extensions.AttachmentCollectionPage;
import com.microsoft.graph.extensions.AttachmentCollectionRequest;
import com.microsoft.graph.extensions.AttachmentCollectionRequestBuilder;
import com.microsoft.graph.extensions.AttachmentRequestBuilder;
import com.microsoft.graph.extensions.IAttachmentCollectionPage;
import com.microsoft.graph.extensions.IAttachmentCollectionRequest;
import com.microsoft.graph.generated.BaseAttachmentCollectionResponse;
import com.microsoft.graph.generated.IBaseAttachmentCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseAttachmentCollectionRequest
extends BaseCollectionRequest<BaseAttachmentCollectionResponse, IAttachmentCollectionPage>
implements IBaseAttachmentCollectionRequest {
    public BaseAttachmentCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseAttachmentCollectionResponse.class, IAttachmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IAttachmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseAttachmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAttachmentCollectionPage get() throws ClientException {
        BaseAttachmentCollectionResponse response = (BaseAttachmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Attachment newAttachment, ICallback<Attachment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AttachmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newAttachment, callback);
    }

    @Override
    public Attachment post(Attachment newAttachment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AttachmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newAttachment);
    }

    @Override
    public IAttachmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (AttachmentCollectionRequest)this;
    }

    @Override
    public IAttachmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (AttachmentCollectionRequest)this;
    }

    @Override
    public IAttachmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (AttachmentCollectionRequest)this;
    }

    public IAttachmentCollectionPage buildFromResponse(BaseAttachmentCollectionResponse response) {
        AttachmentCollectionRequestBuilder builder = response.nextLink != null ? new AttachmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AttachmentCollectionPage page = new AttachmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

