// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

import com.google.gson.JsonObject;
import com.google.gson.annotations.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Range Border Item At Request.
 */
public interface IBaseWorkbookRangeBorderItemAtRequest {

    /**
     * Patches the WorkbookRangeBorderItemAt
     *
     * @param srcWorkbookRangeBorder The WorkbookRangeBorder with which to PATCH
     * @param callback The callback to be called after success or failure
     */
    void patch(WorkbookRangeBorder srcWorkbookRangeBorder, final ICallback<WorkbookRangeBorder> callback);

    /**
     * Patches the WorkbookRangeBorderItemAt
     *
     * @param srcWorkbookRangeBorder The WorkbookRangeBorder with which to PATCH
     * @return The WorkbookRangeBorder
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
    WorkbookRangeBorder patch(WorkbookRangeBorder srcWorkbookRangeBorder) throws ClientException;

    /**
     * Puts the WorkbookRangeBorderItemAt
     *
     * @param srcWorkbookRangeBorder The WorkbookRangeBorder to PUT
     * @param callback The callback to be called after success or failure
     */
    void put(WorkbookRangeBorder srcWorkbookRangeBorder, final ICallback<WorkbookRangeBorder> callback);

    /**
     * Puts the WorkbookRangeBorderItemAt
     *
     * @param srcWorkbookRangeBorder The WorkbookRangeBorder to PUT
     * @return The WorkbookRangeBorder
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     WorkbookRangeBorder put(WorkbookRangeBorder srcWorkbookRangeBorder) throws ClientException;
    /**
     * Gets the WorkbookRangeBorder
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookRangeBorder> callback);

    /**
     * Gets the WorkbookRangeBorder
     *
     * @return The WorkbookRangeBorder
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    WorkbookRangeBorder get() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IWorkbookRangeBorderItemAtRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IWorkbookRangeBorderItemAtRequest expand(final String value);

}
