// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base User Request Builder.
 */
public interface IBaseUserRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     */
    IUserRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     */
    IUserRequest buildRequest(final List<Option> requestOptions);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getOwnedDevices();

    IDirectoryObjectWithReferenceRequestBuilder getOwnedDevices(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getRegisteredDevices();

    IDirectoryObjectWithReferenceRequestBuilder getRegisteredDevices(final String id);

    /**
     * Gets the request builder for DirectoryObject.
     */
    IDirectoryObjectWithReferenceRequestBuilder getManager();

    IDirectoryObjectCollectionWithReferencesRequestBuilder getDirectReports();

    IDirectoryObjectWithReferenceRequestBuilder getDirectReports(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getMemberOf();

    IDirectoryObjectWithReferenceRequestBuilder getMemberOf(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getCreatedObjects();

    IDirectoryObjectWithReferenceRequestBuilder getCreatedObjects(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getOwnedObjects();

    IDirectoryObjectWithReferenceRequestBuilder getOwnedObjects(final String id);

    IMessageCollectionRequestBuilder getMessages();

    IMessageRequestBuilder getMessages(final String id);

    IMailFolderCollectionRequestBuilder getMailFolders();

    IMailFolderRequestBuilder getMailFolders(final String id);

    /**
     * Gets the request builder for Calendar.
     */
    ICalendarRequestBuilder getCalendar();

    ICalendarCollectionRequestBuilder getCalendars();

    ICalendarRequestBuilder getCalendars(final String id);

    ICalendarGroupCollectionRequestBuilder getCalendarGroups();

    ICalendarGroupRequestBuilder getCalendarGroups(final String id);

    IEventCollectionRequestBuilder getCalendarView();

    IEventRequestBuilder getCalendarView(final String id);

    IEventCollectionRequestBuilder getEvents();

    IEventRequestBuilder getEvents(final String id);

    IContactCollectionRequestBuilder getContacts();

    IContactRequestBuilder getContacts(final String id);

    IContactFolderCollectionRequestBuilder getContactFolders();

    IContactFolderRequestBuilder getContactFolders(final String id);

    /**
     * Gets the request builder for InferenceClassification.
     */
    IInferenceClassificationRequestBuilder getInferenceClassification();

    /**
     * Gets the request builder for ProfilePhoto.
     */
    IProfilePhotoRequestBuilder getPhoto();

    /**
     * Gets the request builder for Drive.
     */
    IDriveRequestBuilder getDrive();

    IDriveCollectionRequestBuilder getDrives();

    IDriveRequestBuilder getDrives(final String id);
    IUserAssignLicenseRequestBuilder getAssignLicense(final List<AssignedLicense> addLicenses, final List<java.util.UUID> removeLicenses);
    IUserChangePasswordRequestBuilder getChangePassword(final String currentPassword, final String newPassword);
    IUserSendMailRequestBuilder getSendMail(final Message message, final Boolean saveToSentItems);

    IUserReminderViewCollectionRequestBuilder getReminderView(final String startDateTime, final String endDateTime);

}
