// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range Request.
 */
public class BaseWorkbookRangeRequest extends BaseRequest implements IBaseWorkbookRangeRequest {

    /**
     * The request for the WorkbookRange
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookRangeRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookRange from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookRange> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookRange from the service
     * @return The WorkbookRange from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRange get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookRange with a source
     * @param sourceWorkbookRange The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookRange sourceWorkbookRange, final ICallback<WorkbookRange> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookRange);
    }

    /**
     * Patches this WorkbookRange with a source
     * @param sourceWorkbookRange The source object with updates
     * @return The updated WorkbookRange
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRange patch(final WorkbookRange sourceWorkbookRange) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRange);
    }

    /**
     * Creates a WorkbookRange with a new object
     * @param newWorkbookRange The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookRange newWorkbookRange, final ICallback<WorkbookRange> callback) {
        send(HttpMethod.POST, callback, newWorkbookRange);
    }

    /**
     * Creates a WorkbookRange with a new object
     * @param newWorkbookRange The new object to create
     * @return The created WorkbookRange
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRange post(final WorkbookRange newWorkbookRange) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRange);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookRangeRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookRangeRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookRangeRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookRangeRequest)this;
     }

}
