// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range Border Item At Request.
 */
public class BaseWorkbookRangeBorderItemAtRequest extends BaseRequest implements IBaseWorkbookRangeBorderItemAtRequest {

    /**
     * The request for this WorkbookRangeBorderItemAt
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookRangeBorderItemAtRequest(final String requestUrl, final IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookRangeBorder.class);
    }

    /**
     * Patches the WorkbookRangeBorderItemAt
     * @param srcWorkbookRangeBorder The WorkbookRangeBorder with which to PATCH
     * @param callback The callback to be called after success or failure
     */
    public void patch(WorkbookRangeBorder srcWorkbookRangeBorder, final ICallback<WorkbookRangeBorder> callback) {
        send(HttpMethod.PATCH, callback, srcWorkbookRangeBorder);
    }

    /**
     * Patches the WorkbookRangeBorderItemAt
     *
     * @param srcWorkbookRangeBorder The WorkbookRangeBorder with which to PATCH
     * @return The WorkbookRangeBorder
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     public WorkbookRangeBorder patch(WorkbookRangeBorder srcWorkbookRangeBorder) throws ClientException {
        return this.send(HttpMethod.PATCH, srcWorkbookRangeBorder);
    }

    /**
     * Puts the WorkbookRangeBorderItemAt
     *
     * @param srcWorkbookRangeBorder The WorkbookRangeBorder to PUT
     * @param callback The callback to be called after success or failure
     */
    public void put(WorkbookRangeBorder srcWorkbookRangeBorder, final ICallback<WorkbookRangeBorder> callback) {
        send(HttpMethod.PUT, callback, srcWorkbookRangeBorder);
    }

    /**
     * Puts the WorkbookRangeBorderItemAt
     *
     * @param srcWorkbookRangeBorder The WorkbookRangeBorder to PUT
     * @return The WorkbookRangeBorder
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     public WorkbookRangeBorder put(WorkbookRangeBorder srcWorkbookRangeBorder) throws ClientException {
        return this.send(HttpMethod.PUT, srcWorkbookRangeBorder);
    }
    /**
     * Gets the WorkbookRangeBorder
     *
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookRangeBorder> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookRangeBorder
     *
     * @return The WorkbookRangeBorder
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public WorkbookRangeBorder get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IWorkbookRangeBorderItemAtRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (WorkbookRangeBorderItemAtRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IWorkbookRangeBorderItemAtRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (WorkbookRangeBorderItemAtRequest)this;
    }

}
