// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Rate Request Builder.
 */
public class BaseWorkbookFunctionsRateRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsRate
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsRateRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type, final com.google.gson.JsonElement guess) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("nper", nper);
        mBodyParams.put("pmt", pmt);
        mBodyParams.put("pv", pv);
        mBodyParams.put("fv", fv);
        mBodyParams.put("type", type);
        mBodyParams.put("guess", guess);
    }

    /**
     * Creates the IWorkbookFunctionsRateRequest
     *
     * @return The IWorkbookFunctionsRateRequest instance
     */
    public IWorkbookFunctionsRateRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsRateRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsRateRequest instance
     */
    public IWorkbookFunctionsRateRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsRateRequest request = new WorkbookFunctionsRateRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("nper")) {
            request.mBody.nper = getParameter("nper");
        }

        if (hasParameter("pmt")) {
            request.mBody.pmt = getParameter("pmt");
        }

        if (hasParameter("pv")) {
            request.mBody.pv = getParameter("pv");
        }

        if (hasParameter("fv")) {
            request.mBody.fv = getParameter("fv");
        }

        if (hasParameter("type")) {
            request.mBody.type = getParameter("type");
        }

        if (hasParameter("guess")) {
            request.mBody.guess = getParameter("guess");
        }

        return request;
    }
}
