// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Find BRequest Builder.
 */
public class BaseWorkbookFunctionsFindBRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsFindB
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsFindBRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement findText, final com.google.gson.JsonElement withinText, final com.google.gson.JsonElement startNum) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("findText", findText);
        mBodyParams.put("withinText", withinText);
        mBodyParams.put("startNum", startNum);
    }

    /**
     * Creates the IWorkbookFunctionsFindBRequest
     *
     * @return The IWorkbookFunctionsFindBRequest instance
     */
    public IWorkbookFunctionsFindBRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsFindBRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsFindBRequest instance
     */
    public IWorkbookFunctionsFindBRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsFindBRequest request = new WorkbookFunctionsFindBRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("findText")) {
            request.mBody.findText = getParameter("findText");
        }

        if (hasParameter("withinText")) {
            request.mBody.withinText = getParameter("withinText");
        }

        if (hasParameter("startNum")) {
            request.mBody.startNum = getParameter("startNum");
        }

        return request;
    }
}
