// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Effect Request Builder.
 */
public class BaseWorkbookFunctionsEffectRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsEffect
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsEffectRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement nominalRate, final com.google.gson.JsonElement npery) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("nominalRate", nominalRate);
        mBodyParams.put("npery", npery);
    }

    /**
     * Creates the IWorkbookFunctionsEffectRequest
     *
     * @return The IWorkbookFunctionsEffectRequest instance
     */
    public IWorkbookFunctionsEffectRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsEffectRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsEffectRequest instance
     */
    public IWorkbookFunctionsEffectRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsEffectRequest request = new WorkbookFunctionsEffectRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("nominalRate")) {
            request.mBody.nominalRate = getParameter("nominalRate");
        }

        if (hasParameter("npery")) {
            request.mBody.npery = getParameter("npery");
        }

        return request;
    }
}
