// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Bitor Request Builder.
 */
public class BaseWorkbookFunctionsBitorRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsBitor
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsBitorRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("number1", number1);
        mBodyParams.put("number2", number2);
    }

    /**
     * Creates the IWorkbookFunctionsBitorRequest
     *
     * @return The IWorkbookFunctionsBitorRequest instance
     */
    public IWorkbookFunctionsBitorRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsBitorRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsBitorRequest instance
     */
    public IWorkbookFunctionsBitorRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsBitorRequest request = new WorkbookFunctionsBitorRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("number1")) {
            request.mBody.number1 = getParameter("number1");
        }

        if (hasParameter("number2")) {
            request.mBody.number2 = getParameter("number2");
        }

        return request;
    }
}
