// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Filter Apply Request Builder.
 */
public class BaseWorkbookFilterApplyRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFilterApply
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFilterApplyRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final WorkbookFilterCriteria criteria) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("criteria", criteria);
    }

    /**
     * Creates the IWorkbookFilterApplyRequest
     *
     * @return The IWorkbookFilterApplyRequest instance
     */
    public IWorkbookFilterApplyRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFilterApplyRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFilterApplyRequest instance
     */
    public IWorkbookFilterApplyRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFilterApplyRequest request = new WorkbookFilterApplyRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("criteria")) {
            request.mBody.criteria = getParameter("criteria");
        }

        return request;
    }
}
