// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Subscription Collection Request.
 */
public class BaseSubscriptionCollectionRequest extends BaseCollectionRequest<BaseSubscriptionCollectionResponse, ISubscriptionCollectionPage> implements IBaseSubscriptionCollectionRequest {

    /**
     * The request builder for this collection of Subscription
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseSubscriptionCollectionRequest(final String requestUrl, IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSubscriptionCollectionResponse.class, ISubscriptionCollectionPage.class);
    }

    public void get(final ICallback<ISubscriptionCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ISubscriptionCollectionPage get() throws ClientException {
        final BaseSubscriptionCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Subscription newSubscription, final ICallback<Subscription> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new SubscriptionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newSubscription, callback);
    }

    public Subscription post(final Subscription newSubscription) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new SubscriptionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newSubscription);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public ISubscriptionCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (SubscriptionCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public ISubscriptionCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (SubscriptionCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public ISubscriptionCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (SubscriptionCollectionRequest)this;
    }

    public ISubscriptionCollectionPage buildFromResponse(final BaseSubscriptionCollectionResponse response) {
        final ISubscriptionCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new SubscriptionCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final SubscriptionCollectionPage page = new SubscriptionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
