// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Event.
 */
public class BaseEvent extends OutlookItem implements IJsonBackedObject {


    public BaseEvent() {
        oDataType = "microsoft.graph.event";
    }

    /**
     * The Original Start Time Zone.
     */
    @SerializedName("originalStartTimeZone")
    @Expose
    public String originalStartTimeZone;

    /**
     * The Original End Time Zone.
     */
    @SerializedName("originalEndTimeZone")
    @Expose
    public String originalEndTimeZone;

    /**
     * The Response Status.
     */
    @SerializedName("responseStatus")
    @Expose
    public ResponseStatus responseStatus;

    /**
     * The ICal UId.
     */
    @SerializedName("iCalUId")
    @Expose
    public String iCalUId;

    /**
     * The Reminder Minutes Before Start.
     */
    @SerializedName("reminderMinutesBeforeStart")
    @Expose
    public Integer reminderMinutesBeforeStart;

    /**
     * The Is Reminder On.
     */
    @SerializedName("isReminderOn")
    @Expose
    public Boolean isReminderOn;

    /**
     * The Has Attachments.
     */
    @SerializedName("hasAttachments")
    @Expose
    public Boolean hasAttachments;

    /**
     * The Subject.
     */
    @SerializedName("subject")
    @Expose
    public String subject;

    /**
     * The Body.
     */
    @SerializedName("body")
    @Expose
    public ItemBody body;

    /**
     * The Body Preview.
     */
    @SerializedName("bodyPreview")
    @Expose
    public String bodyPreview;

    /**
     * The Importance.
     */
    @SerializedName("importance")
    @Expose
    public Importance importance;

    /**
     * The Sensitivity.
     */
    @SerializedName("sensitivity")
    @Expose
    public Sensitivity sensitivity;

    /**
     * The Start.
     */
    @SerializedName("start")
    @Expose
    public DateTimeTimeZone start;

    /**
     * The Original Start.
     */
    @SerializedName("originalStart")
    @Expose
    public java.util.Calendar originalStart;

    /**
     * The End.
     */
    @SerializedName("end")
    @Expose
    public DateTimeTimeZone end;

    /**
     * The Location.
     */
    @SerializedName("location")
    @Expose
    public Location location;

    /**
     * The Is All Day.
     */
    @SerializedName("isAllDay")
    @Expose
    public Boolean isAllDay;

    /**
     * The Is Cancelled.
     */
    @SerializedName("isCancelled")
    @Expose
    public Boolean isCancelled;

    /**
     * The Is Organizer.
     */
    @SerializedName("isOrganizer")
    @Expose
    public Boolean isOrganizer;

    /**
     * The Recurrence.
     */
    @SerializedName("recurrence")
    @Expose
    public PatternedRecurrence recurrence;

    /**
     * The Response Requested.
     */
    @SerializedName("responseRequested")
    @Expose
    public Boolean responseRequested;

    /**
     * The Series Master Id.
     */
    @SerializedName("seriesMasterId")
    @Expose
    public String seriesMasterId;

    /**
     * The Show As.
     */
    @SerializedName("showAs")
    @Expose
    public FreeBusyStatus showAs;

    /**
     * The Type.
     */
    @SerializedName("type")
    @Expose
    public EventType type;

    /**
     * The Attendees.
     */
    @SerializedName("attendees")
    @Expose
    public List<Attendee> attendees;

    /**
     * The Organizer.
     */
    @SerializedName("organizer")
    @Expose
    public Recipient organizer;

    /**
     * The Web Link.
     */
    @SerializedName("webLink")
    @Expose
    public String webLink;

    /**
     * The Online Meeting Url.
     */
    @SerializedName("onlineMeetingUrl")
    @Expose
    public String onlineMeetingUrl;

    /**
     * The Calendar.
     */
    @SerializedName("calendar")
    @Expose
    public Calendar calendar;

    /**
     * The Instances.
     */
    public transient EventCollectionPage instances;

    /**
     * The Extensions.
     */
    public transient ExtensionCollectionPage extensions;

    /**
     * The Attachments.
     */
    public transient AttachmentCollectionPage attachments;

    /**
     * The Single Value Extended Properties.
     */
    public transient SingleValueLegacyExtendedPropertyCollectionPage singleValueExtendedProperties;

    /**
     * The Multi Value Extended Properties.
     */
    public transient MultiValueLegacyExtendedPropertyCollectionPage multiValueExtendedProperties;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;


        if (json.has("instances")) {
            final BaseEventCollectionResponse response = new BaseEventCollectionResponse();
            if (json.has("instances@odata.nextLink")) {
                response.nextLink = json.get("instances@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("instances").toString(), JsonObject[].class);
            final Event[] array = new Event[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Event.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            instances = new EventCollectionPage(response, null);
        }

        if (json.has("extensions")) {
            final BaseExtensionCollectionResponse response = new BaseExtensionCollectionResponse();
            if (json.has("extensions@odata.nextLink")) {
                response.nextLink = json.get("extensions@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("extensions").toString(), JsonObject[].class);
            final Extension[] array = new Extension[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Extension.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            extensions = new ExtensionCollectionPage(response, null);
        }

        if (json.has("attachments")) {
            final BaseAttachmentCollectionResponse response = new BaseAttachmentCollectionResponse();
            if (json.has("attachments@odata.nextLink")) {
                response.nextLink = json.get("attachments@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("attachments").toString(), JsonObject[].class);
            final Attachment[] array = new Attachment[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Attachment.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            attachments = new AttachmentCollectionPage(response, null);
        }

        if (json.has("singleValueExtendedProperties")) {
            final BaseSingleValueLegacyExtendedPropertyCollectionResponse response = new BaseSingleValueLegacyExtendedPropertyCollectionResponse();
            if (json.has("singleValueExtendedProperties@odata.nextLink")) {
                response.nextLink = json.get("singleValueExtendedProperties@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("singleValueExtendedProperties").toString(), JsonObject[].class);
            final SingleValueLegacyExtendedProperty[] array = new SingleValueLegacyExtendedProperty[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SingleValueLegacyExtendedProperty.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            singleValueExtendedProperties = new SingleValueLegacyExtendedPropertyCollectionPage(response, null);
        }

        if (json.has("multiValueExtendedProperties")) {
            final BaseMultiValueLegacyExtendedPropertyCollectionResponse response = new BaseMultiValueLegacyExtendedPropertyCollectionResponse();
            if (json.has("multiValueExtendedProperties@odata.nextLink")) {
                response.nextLink = json.get("multiValueExtendedProperties@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("multiValueExtendedProperties").toString(), JsonObject[].class);
            final MultiValueLegacyExtendedProperty[] array = new MultiValueLegacyExtendedProperty[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), MultiValueLegacyExtendedProperty.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            multiValueExtendedProperties = new MultiValueLegacyExtendedPropertyCollectionPage(response, null);
        }
    }
}
