/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IWorkbookNamedItemCollectionPage;
import com.microsoft.graph.extensions.IWorkbookNamedItemCollectionRequest;
import com.microsoft.graph.extensions.WorkbookNamedItem;
import com.microsoft.graph.extensions.WorkbookNamedItemCollectionPage;
import com.microsoft.graph.extensions.WorkbookNamedItemCollectionRequest;
import com.microsoft.graph.extensions.WorkbookNamedItemCollectionRequestBuilder;
import com.microsoft.graph.extensions.WorkbookNamedItemRequestBuilder;
import com.microsoft.graph.generated.BaseWorkbookNamedItemCollectionResponse;
import com.microsoft.graph.generated.IBaseWorkbookNamedItemCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseWorkbookNamedItemCollectionRequest
extends BaseCollectionRequest<BaseWorkbookNamedItemCollectionResponse, IWorkbookNamedItemCollectionPage>
implements IBaseWorkbookNamedItemCollectionRequest {
    public BaseWorkbookNamedItemCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookNamedItemCollectionResponse.class, IWorkbookNamedItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookNamedItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookNamedItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookNamedItemCollectionPage get() throws ClientException {
        BaseWorkbookNamedItemCollectionResponse response = (BaseWorkbookNamedItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookNamedItem newWorkbookNamedItem, ICallback<WorkbookNamedItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookNamedItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newWorkbookNamedItem, callback);
    }

    @Override
    public WorkbookNamedItem post(WorkbookNamedItem newWorkbookNamedItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookNamedItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newWorkbookNamedItem);
    }

    @Override
    public IWorkbookNamedItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookNamedItemCollectionRequest)this;
    }

    @Override
    public IWorkbookNamedItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookNamedItemCollectionRequest)this;
    }

    @Override
    public IWorkbookNamedItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookNamedItemCollectionRequest)this;
    }

    public IWorkbookNamedItemCollectionPage buildFromResponse(BaseWorkbookNamedItemCollectionResponse response) {
        WorkbookNamedItemCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookNamedItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookNamedItemCollectionPage page = new WorkbookNamedItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

