/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DriveItem;
import com.microsoft.graph.extensions.DriveItemCollectionPage;
import com.microsoft.graph.extensions.DriveItemCollectionRequest;
import com.microsoft.graph.extensions.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.extensions.DriveItemRequestBuilder;
import com.microsoft.graph.extensions.IDriveItemCollectionPage;
import com.microsoft.graph.extensions.IDriveItemCollectionRequest;
import com.microsoft.graph.generated.BaseDriveItemCollectionResponse;
import com.microsoft.graph.generated.IBaseDriveItemCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDriveItemCollectionRequest
extends BaseCollectionRequest<BaseDriveItemCollectionResponse, IDriveItemCollectionPage>
implements IBaseDriveItemCollectionRequest {
    public BaseDriveItemCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDriveItemCollectionResponse.class, IDriveItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemCollectionPage get() throws ClientException {
        BaseDriveItemCollectionResponse response = (BaseDriveItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DriveItem newDriveItem, ICallback<DriveItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newDriveItem, callback);
    }

    @Override
    public DriveItem post(DriveItem newDriveItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DriveItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newDriveItem);
    }

    @Override
    public IDriveItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DriveItemCollectionRequest)this;
    }

    @Override
    public IDriveItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DriveItemCollectionRequest)this;
    }

    @Override
    public IDriveItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DriveItemCollectionRequest)this;
    }

    public IDriveItemCollectionPage buildFromResponse(BaseDriveItemCollectionResponse response) {
        DriveItemCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveItemCollectionPage page = new DriveItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

