// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Format Protection Request.
 */
public interface IBaseWorkbookFormatProtectionRequest extends IHttpRequest {

    /**
     * Gets the WorkbookFormatProtection from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookFormatProtection> callback);

    /**
     * Gets the WorkbookFormatProtection from the service
     * @return The WorkbookFormatProtection from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookFormatProtection get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookFormatProtection with a source
     * @param sourceWorkbookFormatProtection The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookFormatProtection sourceWorkbookFormatProtection, final ICallback<WorkbookFormatProtection> callback);

    /**
     * Patches this WorkbookFormatProtection with a source
     * @param sourceWorkbookFormatProtection The source object with updates
     * @return The updated WorkbookFormatProtection
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookFormatProtection patch(final WorkbookFormatProtection sourceWorkbookFormatProtection) throws ClientException;

    /**
     * Posts a WorkbookFormatProtection with a new object
     * @param newWorkbookFormatProtection The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookFormatProtection newWorkbookFormatProtection, final ICallback<WorkbookFormatProtection> callback);

    /**
     * Posts a WorkbookFormatProtection with a new object
     * @param newWorkbookFormatProtection The new object to create
     * @return The created WorkbookFormatProtection
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookFormatProtection post(final WorkbookFormatProtection newWorkbookFormatProtection) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookFormatProtectionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookFormatProtectionRequest expand(final String value);

}
