// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Multi Value Legacy Extended Property Request.
 */
public interface IBaseMultiValueLegacyExtendedPropertyRequest extends IHttpRequest {

    /**
     * Gets the MultiValueLegacyExtendedProperty from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<MultiValueLegacyExtendedProperty> callback);

    /**
     * Gets the MultiValueLegacyExtendedProperty from the service
     * @return The MultiValueLegacyExtendedProperty from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MultiValueLegacyExtendedProperty get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MultiValueLegacyExtendedProperty with a source
     * @param sourceMultiValueLegacyExtendedProperty The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final MultiValueLegacyExtendedProperty sourceMultiValueLegacyExtendedProperty, final ICallback<MultiValueLegacyExtendedProperty> callback);

    /**
     * Patches this MultiValueLegacyExtendedProperty with a source
     * @param sourceMultiValueLegacyExtendedProperty The source object with updates
     * @return The updated MultiValueLegacyExtendedProperty
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MultiValueLegacyExtendedProperty patch(final MultiValueLegacyExtendedProperty sourceMultiValueLegacyExtendedProperty) throws ClientException;

    /**
     * Posts a MultiValueLegacyExtendedProperty with a new object
     * @param newMultiValueLegacyExtendedProperty The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final MultiValueLegacyExtendedProperty newMultiValueLegacyExtendedProperty, final ICallback<MultiValueLegacyExtendedProperty> callback);

    /**
     * Posts a MultiValueLegacyExtendedProperty with a new object
     * @param newMultiValueLegacyExtendedProperty The new object to create
     * @return The created MultiValueLegacyExtendedProperty
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    MultiValueLegacyExtendedProperty post(final MultiValueLegacyExtendedProperty newMultiValueLegacyExtendedProperty) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseMultiValueLegacyExtendedPropertyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseMultiValueLegacyExtendedPropertyRequest expand(final String value);

}
