// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Table Column Item At Request.
 */
public class BaseWorkbookTableColumnItemAtRequest extends BaseRequest implements IBaseWorkbookTableColumnItemAtRequest {

    /**
     * The request for this WorkbookTableColumnItemAt
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookTableColumnItemAtRequest(final String requestUrl, final IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookTableColumn.class);
    }

    /**
     * Patches the WorkbookTableColumnItemAt
     * @param srcWorkbookTableColumn The WorkbookTableColumn with which to PATCH
     * @param callback The callback to be called after success or failure
     */
    public void patch(WorkbookTableColumn srcWorkbookTableColumn, final ICallback<WorkbookTableColumn> callback) {
        send(HttpMethod.PATCH, callback, srcWorkbookTableColumn);
    }

    /**
     * Patches the WorkbookTableColumnItemAt
     *
     * @param srcWorkbookTableColumn The WorkbookTableColumn with which to PATCH
     * @return The WorkbookTableColumn
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     public WorkbookTableColumn patch(WorkbookTableColumn srcWorkbookTableColumn) throws ClientException {
        return this.send(HttpMethod.PATCH, srcWorkbookTableColumn);
    }

    /**
     * Puts the WorkbookTableColumnItemAt
     *
     * @param srcWorkbookTableColumn The WorkbookTableColumn to PUT
     * @param callback The callback to be called after success or failure
     */
    public void put(WorkbookTableColumn srcWorkbookTableColumn, final ICallback<WorkbookTableColumn> callback) {
        send(HttpMethod.PUT, callback, srcWorkbookTableColumn);
    }

    /**
     * Puts the WorkbookTableColumnItemAt
     *
     * @param srcWorkbookTableColumn The WorkbookTableColumn to PUT
     * @return The WorkbookTableColumn
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     public WorkbookTableColumn put(WorkbookTableColumn srcWorkbookTableColumn) throws ClientException {
        return this.send(HttpMethod.PUT, srcWorkbookTableColumn);
    }
    /**
     * Gets the WorkbookTableColumn
     *
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookTableColumn> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookTableColumn
     *
     * @return The WorkbookTableColumn
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public WorkbookTableColumn get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IWorkbookTableColumnItemAtRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (WorkbookTableColumnItemAtRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IWorkbookTableColumnItemAtRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (WorkbookTableColumnItemAtRequest)this;
    }

}
