// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range Format Autofit Rows Request Builder.
 */
public class BaseWorkbookRangeFormatAutofitRowsRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookRangeFormatAutofitRows
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookRangeFormatAutofitRowsRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IWorkbookRangeFormatAutofitRowsRequest
     *
     * @return The IWorkbookRangeFormatAutofitRowsRequest instance
     */
    public IWorkbookRangeFormatAutofitRowsRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookRangeFormatAutofitRowsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookRangeFormatAutofitRowsRequest instance
     */
    public IWorkbookRangeFormatAutofitRowsRequest buildRequest(final List<Option> requestOptions) {
        WorkbookRangeFormatAutofitRowsRequest request = new WorkbookRangeFormatAutofitRowsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
