// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Attachment Request Builder.
 */
public class BaseAttachmentRequestBuilder extends BaseRequestBuilder implements IBaseAttachmentRequestBuilder {

    /**
     * The request builder for the Attachment
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseAttachmentRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     */
    public IAttachmentRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     */
    public IAttachmentRequest buildRequest(final List<Option> requestOptions) {
        return new AttachmentRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IFileAttachmentRequestBuilder fileAttachment() {
        return new FileAttachmentRequestBuilder(getRequestUrlWithAdditionalSegment("fileAttachment"), getClient(), null);
    }

    public IItemAttachmentRequestBuilder itemAttachment() {
        return new ItemAttachmentRequestBuilder(getRequestUrlWithAdditionalSegment("itemAttachment"), getClient(), null);
    }

    public IReferenceAttachmentRequestBuilder referenceAttachment() {
        return new ReferenceAttachmentRequestBuilder(getRequestUrlWithAdditionalSegment("referenceAttachment"), getClient(), null);
    }
}
