// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Outlook Item Request.
 */
public class BaseOutlookItemRequest extends BaseRequest implements IBaseOutlookItemRequest {

    /**
     * The request for the OutlookItem
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseOutlookItemRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> options,
            final Class responseClass) {
        super(requestUrl, client, options, responseClass);
    }

    /**
     * Gets the OutlookItem from the service
     * @param callback The callback to be called after success or failure.
     */
    public void getOutlookItem(final ICallback<OutlookItem> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OutlookItem from the service
     * @return The OutlookItem from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OutlookItem getOutlookItem() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this OutlookItem with a source
     * @param sourceOutlookItem The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final OutlookItem sourceOutlookItem, final ICallback<OutlookItem> callback) {
        send(HttpMethod.PATCH, callback, sourceOutlookItem);
    }

    /**
     * Patches this OutlookItem with a source
     * @param sourceOutlookItem The source object with updates
     * @return The updated OutlookItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OutlookItem patch(final OutlookItem sourceOutlookItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceOutlookItem);
    }

    /**
     * Creates a OutlookItem with a new object
     * @param newOutlookItem The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final OutlookItem newOutlookItem, final ICallback<OutlookItem> callback) {
        send(HttpMethod.POST, callback, newOutlookItem);
    }

    /**
     * Creates a OutlookItem with a new object
     * @param newOutlookItem The new object to create
     * @return The created OutlookItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OutlookItem post(final OutlookItem newOutlookItem) throws ClientException {
        return send(HttpMethod.POST, newOutlookItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IOutlookItemRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (OutlookItemRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IOutlookItemRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (OutlookItemRequest)this;
     }

}
