/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.CalendarGroup;
import com.microsoft.graph.extensions.CalendarGroupCollectionPage;
import com.microsoft.graph.extensions.CalendarGroupCollectionRequest;
import com.microsoft.graph.extensions.CalendarGroupCollectionRequestBuilder;
import com.microsoft.graph.extensions.CalendarGroupRequestBuilder;
import com.microsoft.graph.extensions.ICalendarGroupCollectionPage;
import com.microsoft.graph.extensions.ICalendarGroupCollectionRequest;
import com.microsoft.graph.generated.BaseCalendarGroupCollectionResponse;
import com.microsoft.graph.generated.IBaseCalendarGroupCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseCalendarGroupCollectionRequest
extends BaseCollectionRequest<BaseCalendarGroupCollectionResponse, ICalendarGroupCollectionPage>
implements IBaseCalendarGroupCollectionRequest {
    public BaseCalendarGroupCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseCalendarGroupCollectionResponse.class, ICalendarGroupCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ICalendarGroupCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseCalendarGroupCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICalendarGroupCollectionPage get() throws ClientException {
        BaseCalendarGroupCollectionResponse response = (BaseCalendarGroupCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(CalendarGroup newCalendarGroup, ICallback<CalendarGroup> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CalendarGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newCalendarGroup, callback);
    }

    @Override
    public CalendarGroup post(CalendarGroup newCalendarGroup) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CalendarGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newCalendarGroup);
    }

    @Override
    public ICalendarGroupCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (CalendarGroupCollectionRequest)this;
    }

    @Override
    public ICalendarGroupCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (CalendarGroupCollectionRequest)this;
    }

    @Override
    public ICalendarGroupCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (CalendarGroupCollectionRequest)this;
    }

    public ICalendarGroupCollectionPage buildFromResponse(BaseCalendarGroupCollectionResponse response) {
        CalendarGroupCollectionRequestBuilder builder = response.nextLink != null ? new CalendarGroupCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CalendarGroupCollectionPage page = new CalendarGroupCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

