// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base User Assign License Request Builder.
 */
public class BaseUserAssignLicenseRequestBuilder extends BasePostMethodRequestBuilder {

    /**
     * The request builder for this UserAssignLicense
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseUserAssignLicenseRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options, final List<AssignedLicense> addLicenses, final List<java.util.UUID> removeLicenses) {
        super(requestUrl, client, options);
        mBodyParams.put("addLicenses", addLicenses);
        mBodyParams.put("removeLicenses", removeLicenses);
    }

    /**
     * Creates the IUserAssignLicenseRequest
     *
     * @return The IUserAssignLicenseRequest instance
     */
    public IUserAssignLicenseRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IUserAssignLicenseRequest with specific options instead of the existing options
     *
     * @param options the options for the request
     * @return The IUserAssignLicenseRequest instance
     */
    public IUserAssignLicenseRequest buildRequest(final List<Option> options) {
        UserAssignLicenseRequest request = new UserAssignLicenseRequest(
                getRequestUrl(),
                getClient(),
                options
        );

        if (hasParameter("addLicenses")) {
            request.mBody.addLicenses = getParameter("addLicenses");
        }
        if (hasParameter("removeLicenses")) {
            request.mBody.removeLicenses = getParameter("removeLicenses");
        }

        return request;
    }
}
