// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Message Copy Request Builder.
 */
public class BaseMessageCopyRequestBuilder extends BasePostMethodRequestBuilder {

    /**
     * The request builder for this MessageCopy
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseMessageCopyRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options, final String destinationId) {
        super(requestUrl, client, options);
        mBodyParams.put("destinationId", destinationId);
    }

    /**
     * Creates the IMessageCopyRequest
     *
     * @return The IMessageCopyRequest instance
     */
    public IMessageCopyRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IMessageCopyRequest with specific options instead of the existing options
     *
     * @param options the options for the request
     * @return The IMessageCopyRequest instance
     */
    public IMessageCopyRequest buildRequest(final List<Option> options) {
        MessageCopyRequest request = new MessageCopyRequest(
                getRequestUrl(),
                getClient(),
                options
        );

        if (hasParameter("destinationId")) {
            request.mBody.destinationId = getParameter("destinationId");
        }

        return request;
    }
}
