/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import android.net.Uri;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.GraphErrorCodes;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseRequest
implements IHttpRequest {
    private static final String REQUEST_STATS_HEADER_NAME = "SdkVersion";
    public static final String REQUEST_STATS_HEADER_VALUE_FORMAT_STRING = "graph-android-v%s";
    private HttpMethod mMethod;
    private final String mRequestUrl;
    private final IBaseClient mClient;
    private final List<HeaderOption> mHeadersOptions;
    protected final List<QueryOption> mQueryOptions;
    protected final List<FunctionOption> mFunctionOptions;
    private final Class mResponseClass;

    public BaseRequest(String requestUrl, IBaseClient client, List<Option> options, Class responseClass) {
        this.mRequestUrl = requestUrl;
        this.mClient = client;
        this.mResponseClass = responseClass;
        this.mHeadersOptions = new ArrayList<HeaderOption>();
        this.mQueryOptions = new ArrayList<QueryOption>();
        this.mFunctionOptions = new ArrayList<FunctionOption>();
        if (options != null) {
            for (Option option : options) {
                if (option instanceof HeaderOption) {
                    this.mHeadersOptions.add((HeaderOption)option);
                }
                if (option instanceof QueryOption) {
                    this.mQueryOptions.add((QueryOption)option);
                }
                if (!(option instanceof FunctionOption)) continue;
                this.mFunctionOptions.add((FunctionOption)option);
            }
        }
        HeaderOption requestStatsHeader = new HeaderOption(REQUEST_STATS_HEADER_NAME, String.format(REQUEST_STATS_HEADER_VALUE_FORMAT_STRING, "0.9.3"));
        this.mHeadersOptions.add(requestStatsHeader);
    }

    @Override
    public URL getRequestUrl() {
        String requestUrl = this.addFunctionParameters();
        Uri baseUrl = Uri.parse((String)requestUrl);
        Uri.Builder uriBuilder = baseUrl.buildUpon();
        for (QueryOption option : this.mQueryOptions) {
            uriBuilder.appendQueryParameter(option.getName(), option.getValue());
        }
        try {
            return new URL(uriBuilder.toString());
        }
        catch (MalformedURLException e) {
            throw new ClientException("Invalid URL: " + uriBuilder.toString(), e, GraphErrorCodes.InvalidRequest);
        }
    }

    private String addFunctionParameters() {
        StringBuilder requestUrl = new StringBuilder(this.mRequestUrl);
        if (this.getFunctionOptions().size() > 0) {
            requestUrl.append("(");
            for (int i = 0; i < this.mFunctionOptions.size(); ++i) {
                FunctionOption option = this.mFunctionOptions.get(i);
                requestUrl.append(option.getName());
                requestUrl.append("=");
                if (option.getValue() != null) {
                    requestUrl.append("'" + option.getValue() + "'");
                } else {
                    requestUrl.append("null");
                }
                if (i + 1 >= this.mFunctionOptions.size()) continue;
                requestUrl.append(",");
            }
            requestUrl.append(")");
        }
        return requestUrl.toString();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.mMethod;
    }

    @Override
    public List<HeaderOption> getHeaders() {
        return this.mHeadersOptions;
    }

    @Override
    public void addHeader(String header, String value) {
        this.mHeadersOptions.add(new HeaderOption(header, value));
    }

    protected <T1, T2> void send(HttpMethod method, ICallback<T1> callback, T2 serializedObject) {
        this.mMethod = method;
        this.mClient.getHttpProvider().send(this, callback, this.mResponseClass, serializedObject);
    }

    protected <T1, T2> T1 send(HttpMethod method, T2 serializedObject) throws ClientException {
        this.mMethod = method;
        return (T1)this.mClient.getHttpProvider().send(this, this.mResponseClass, serializedObject);
    }

    public List<QueryOption> getQueryOptions() {
        return this.mQueryOptions;
    }

    public List<FunctionOption> getFunctionOptions() {
        return this.mFunctionOptions;
    }

    @Override
    public List<Option> getOptions() {
        LinkedList<Option> list = new LinkedList<Option>();
        list.addAll(this.mHeadersOptions);
        list.addAll(this.mQueryOptions);
        list.addAll(this.mFunctionOptions);
        return Collections.unmodifiableList(list);
    }

    public void addQueryOption(QueryOption option) {
        this.getQueryOptions().add(option);
    }

    public void addFunctionOption(FunctionOption option) {
        this.getFunctionOptions().add(option);
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.mMethod = httpMethod;
    }

    public IBaseClient getClient() {
        return this.mClient;
    }

    public Class getResponseType() {
        return this.mResponseClass;
    }
}

