/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IThumbnailSetCollectionPage;
import com.microsoft.graph.extensions.IThumbnailSetCollectionRequest;
import com.microsoft.graph.extensions.ThumbnailSet;
import com.microsoft.graph.extensions.ThumbnailSetCollectionPage;
import com.microsoft.graph.extensions.ThumbnailSetCollectionRequest;
import com.microsoft.graph.extensions.ThumbnailSetCollectionRequestBuilder;
import com.microsoft.graph.extensions.ThumbnailSetRequestBuilder;
import com.microsoft.graph.generated.BaseThumbnailSetCollectionResponse;
import com.microsoft.graph.generated.IBaseThumbnailSetCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseThumbnailSetCollectionRequest
extends BaseCollectionRequest<BaseThumbnailSetCollectionResponse, IThumbnailSetCollectionPage>
implements IBaseThumbnailSetCollectionRequest {
    public BaseThumbnailSetCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseThumbnailSetCollectionResponse.class, IThumbnailSetCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IThumbnailSetCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseThumbnailSetCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IThumbnailSetCollectionPage get() throws ClientException {
        BaseThumbnailSetCollectionResponse response = (BaseThumbnailSetCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ThumbnailSet newThumbnailSet, ICallback<ThumbnailSet> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ThumbnailSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newThumbnailSet, callback);
    }

    @Override
    public ThumbnailSet post(ThumbnailSet newThumbnailSet) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ThumbnailSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newThumbnailSet);
    }

    @Override
    public IThumbnailSetCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ThumbnailSetCollectionRequest)this;
    }

    @Override
    public IThumbnailSetCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ThumbnailSetCollectionRequest)this;
    }

    @Override
    public IThumbnailSetCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ThumbnailSetCollectionRequest)this;
    }

    public IThumbnailSetCollectionPage buildFromResponse(BaseThumbnailSetCollectionResponse response) {
        ThumbnailSetCollectionRequestBuilder builder = response.nextLink != null ? new ThumbnailSetCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ThumbnailSetCollectionPage page = new ThumbnailSetCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

