/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DriveRecentCollectionPage;
import com.microsoft.graph.extensions.DriveRecentCollectionRequestBuilder;
import com.microsoft.graph.extensions.IDriveRecentCollectionPage;
import com.microsoft.graph.extensions.IDriveRecentCollectionRequest;
import com.microsoft.graph.generated.BaseDriveRecentCollectionResponse;
import com.microsoft.graph.generated.IBaseDriveRecentCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDriveRecentCollectionRequest
extends BaseCollectionRequest<BaseDriveRecentCollectionResponse, IDriveRecentCollectionPage>
implements IBaseDriveRecentCollectionRequest {
    public BaseDriveRecentCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseDriveRecentCollectionResponse.class, IDriveRecentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveRecentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveRecentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveRecentCollectionPage get() throws ClientException {
        BaseDriveRecentCollectionResponse response = (BaseDriveRecentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveRecentCollectionPage buildFromResponse(BaseDriveRecentCollectionResponse response) {
        DriveRecentCollectionRequestBuilder builder = response.nextLink != null ? new DriveRecentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveRecentCollectionPage page = new DriveRecentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveRecentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDriveRecentCollectionRequest)((Object)this);
    }

    @Override
    public IDriveRecentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDriveRecentCollectionRequest)((Object)this);
    }

    @Override
    public IDriveRecentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDriveRecentCollectionRequest)((Object)this);
    }
}

