// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Mail Folder Copy Request Builder.
 */
public class BaseMailFolderCopyRequestBuilder extends BasePostMethodRequestBuilder {

    /**
     * The request builder for this MailFolderCopy
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseMailFolderCopyRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options, final String destinationId) {
        super(requestUrl, client, options);
        mBodyParams.put("destinationId", destinationId);
    }

    /**
     * Creates the IMailFolderCopyRequest
     *
     * @return The IMailFolderCopyRequest instance
     */
    public IMailFolderCopyRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IMailFolderCopyRequest with specific options instead of the existing options
     *
     * @param options the options for the request
     * @return The IMailFolderCopyRequest instance
     */
    public IMailFolderCopyRequest buildRequest(final List<Option> options) {
        MailFolderCopyRequest request = new MailFolderCopyRequest(
                getRequestUrl(),
                getClient(),
                options
        );

        if (hasParameter("destinationId")) {
            request.mBody.destinationId = getParameter("destinationId");
        }

        return request;
    }
}
