// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base File Attachment Request.
 */
public interface IBaseFileAttachmentRequest extends IAttachmentRequest {

    /**
     * Gets the FileAttachment from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<FileAttachment> callback);

    /**
     * Gets the FileAttachment from the service
     * @return The FileAttachment from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    FileAttachment get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this FileAttachment with a source
     * @param sourceFileAttachment The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final FileAttachment sourceFileAttachment, final ICallback<FileAttachment> callback);

    /**
     * Patches this FileAttachment with a source
     * @param sourceFileAttachment The source object with updates
     * @return The updated FileAttachment
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    FileAttachment patch(final FileAttachment sourceFileAttachment) throws ClientException;

    /**
     * Posts a FileAttachment with a new object
     * @param newFileAttachment The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final FileAttachment newFileAttachment, final ICallback<FileAttachment> callback);

    /**
     * Posts a FileAttachment with a new object
     * @param newFileAttachment The new object to create
     * @return The created FileAttachment
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    FileAttachment post(final FileAttachment newFileAttachment) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseFileAttachmentRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseFileAttachmentRequest expand(final String value);
}
