// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Drive Item Request Builder.
 */
public interface IBaseDriveItemRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     */
    IDriveItemRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     */
    IDriveItemRequest buildRequest(final List<Option> options);

    /**
     * Gets the request builder for User.
     */
    IUserWithReferenceRequestBuilder getCreatedByUser();

    /**
     * Gets the request builder for User.
     */
    IUserWithReferenceRequestBuilder getLastModifiedByUser();

    IPermissionCollectionRequestBuilder getPermissions();

    IPermissionRequestBuilder getPermissions(final String id);

    IDriveItemCollectionRequestBuilder getChildren();

    IDriveItemRequestBuilder getChildren(final String id);

    IThumbnailSetCollectionRequestBuilder getThumbnails();

    IThumbnailSetRequestBuilder getThumbnails(final String id);

    IDriveItemStreamRequestBuilder getContent();
    IDriveItemCreateLinkRequestBuilder getCreateLink(final String type, final String scope);
    IDriveItemCopyRequestBuilder getCopy(final String name, final ItemReference parentReference);

    IDriveItemSearchCollectionRequestBuilder getSearch(final String q);

    IDriveItemDeltaCollectionRequestBuilder getDelta();

}
