/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.concurrency.IProgressCallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.GraphErrorCodes;
import com.microsoft.graph.http.DefaultConnectionFactory;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.http.IConnection;
import com.microsoft.graph.http.IConnectionFactory;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.logger.LoggerLevel;
import com.microsoft.graph.serializer.ISerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Scanner;

public class DefaultHttpProvider
implements IHttpProvider {
    private final ISerializer mSerializer;
    private final IAuthenticationProvider mAuthenticationProvider;
    private final IExecutors mExecutors;
    private final ILogger mLogger;
    private IConnectionFactory mConnectionFactory;

    public DefaultHttpProvider(ISerializer serializer, IAuthenticationProvider authenticationProvider, IExecutors executors, ILogger logger) {
        this.mSerializer = serializer;
        this.mAuthenticationProvider = authenticationProvider;
        this.mExecutors = executors;
        this.mLogger = logger;
        this.mConnectionFactory = new DefaultConnectionFactory();
    }

    @Override
    public ISerializer getSerializer() {
        return this.mSerializer;
    }

    public <Result, Body> void send(final IHttpRequest request, final ICallback<Result> callback, final Class<Result> resultClass, final Body serializable) {
        final IProgressCallback progressCallback = callback instanceof IProgressCallback ? (IProgressCallback)callback : null;
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpProvider.this.mExecutors.performOnForeground(DefaultHttpProvider.this.sendRequestInternal(request, resultClass, serializable, progressCallback), callback);
                }
                catch (ClientException e) {
                    DefaultHttpProvider.this.mExecutors.performOnForeground(e, callback);
                }
            }
        });
    }

    public <Result, Body> Result send(IHttpRequest request, Class<Result> resultClass, Body serializable) throws ClientException {
        return this.sendRequestInternal(request, resultClass, serializable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Result, Body> Result sendRequestInternal(IHttpRequest request, Class<Result> resultClass, Body serializable, IProgressCallback<Result> progress) throws ClientException {
        int defaultBufferSize = 4096;
        String contentTypeHeaderName = "Content-Type";
        String contentLengthHeaderName = "Content-Length";
        String binaryContentType = "application/octet-stream";
        String jsonContentType = "application/json";
        int httpClientErrorResponseCode = 400;
        int httpNoBodyResponseCode = 204;
        int httpAcceptedResponseCode = 202;
        int httpNotModified = 304;
        try {
            if (this.mAuthenticationProvider != null) {
                this.mAuthenticationProvider.authenticateRequest(request);
            }
            OutputStream out = null;
            InputStream in = null;
            boolean isBinaryStreamInput = false;
            URL requestUrl = request.getRequestUrl();
            this.mLogger.logDebug("Starting to send request, URL " + requestUrl.toString());
            IConnection connection = this.mConnectionFactory.createFromRequest(request);
            try {
                Result writtenSoFar2;
                byte[] bytesToWrite;
                this.mLogger.logDebug("Request Method " + request.getHttpMethod().toString());
                connection.setFollowRedirects(true);
                if (serializable == null) {
                    bytesToWrite = null;
                } else if (serializable instanceof byte[]) {
                    this.mLogger.logDebug("Sending byte[] as request body");
                    bytesToWrite = (byte[])serializable;
                    connection.addRequestHeader("Content-Type", "application/octet-stream");
                    connection.addRequestHeader("Content-Length", "" + bytesToWrite.length);
                } else {
                    this.mLogger.logDebug("Sending " + serializable.getClass().getName() + " as request body");
                    String serializeObject = this.mSerializer.serializeObject(serializable);
                    bytesToWrite = serializeObject.getBytes();
                    connection.addRequestHeader("Content-Type", "application/json");
                    connection.addRequestHeader("Content-Length", "" + bytesToWrite.length);
                }
                if (bytesToWrite != null) {
                    int toWrite;
                    out = connection.getOutputStream();
                    int writtenSoFar2 = 0;
                    BufferedOutputStream bos = new BufferedOutputStream(out);
                    do {
                        toWrite = Math.min(4096, bytesToWrite.length - writtenSoFar2);
                        bos.write(bytesToWrite, writtenSoFar2, toWrite);
                        writtenSoFar2 += toWrite;
                        if (progress == null) continue;
                        this.mExecutors.performOnForeground(writtenSoFar2, bytesToWrite.length, progress);
                    } while (toWrite > 0);
                    bos.close();
                }
                this.mLogger.logDebug(String.format("Response code %d, %s", connection.getResponseCode(), connection.getResponseMessage()));
                if (connection.getResponseCode() >= 400) {
                    this.mLogger.logDebug("Handling error response");
                    in = connection.getInputStream();
                    this.handleErrorResponse(request, serializable, connection);
                }
                if (connection.getResponseCode() == 204 || connection.getResponseCode() == 304) {
                    this.mLogger.logDebug("Handling response with no body");
                    writtenSoFar2 = null;
                    return writtenSoFar2;
                }
                if (connection.getResponseCode() == 202 && connection.getContentLength() <= 0) {
                    this.mLogger.logDebug("Handling response Content-Length = 0");
                    writtenSoFar2 = null;
                    return writtenSoFar2;
                }
                in = new BufferedInputStream(connection.getInputStream());
                Map<String, String> headers = connection.getHeaders();
                String contentType = headers.get("Content-Type");
                if (contentType.contains("application/json")) {
                    this.mLogger.logDebug("Response json");
                    Result Result = this.handleJsonResponse(in, resultClass);
                    return Result;
                }
                this.mLogger.logDebug("Response binary");
                isBinaryStreamInput = true;
                InputStream inputStream = this.handleBinaryStream(in);
                return (Result)inputStream;
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (!isBinaryStreamInput && in != null) {
                    in.close();
                    connection.close();
                }
            }
        }
        catch (GraphServiceException ex) {
            boolean shouldLogVerbosely = this.mLogger.getLoggingLevel() == LoggerLevel.Debug;
            this.mLogger.logError("Graph Service exception " + ex.getMessage(shouldLogVerbosely), ex);
            throw ex;
        }
        catch (Exception ex) {
            ClientException clientException = new ClientException("Error during http request", ex, GraphErrorCodes.GeneralException);
            this.mLogger.logError("Error during http request", clientException);
            throw clientException;
        }
    }

    private <Body> void handleErrorResponse(IHttpRequest request, Body serializable, IConnection connection) throws IOException {
        throw GraphServiceException.createFromConnection(request, serializable, this.mSerializer, connection);
    }

    private InputStream handleBinaryStream(InputStream in) {
        return in;
    }

    private <Result> Result handleJsonResponse(InputStream in, Class<Result> clazz) {
        if (clazz == null) {
            return null;
        }
        String rawJson = DefaultHttpProvider.streamToString(in);
        return this.getSerializer().deserializeObject(rawJson, clazz);
    }

    void setConnectionFactory(IConnectionFactory factory) {
        this.mConnectionFactory = factory;
    }

    public static String streamToString(InputStream input) {
        String httpStreamEncoding = "UTF-8";
        String endOfFile = "\\A";
        Scanner scanner = new Scanner(input, "UTF-8").useDelimiter("\\A");
        return scanner.next();
    }
}

