// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Post Reply Request Builder.
 */
public class BasePostReplyRequestBuilder extends BaseRequestBuilder {

    public final Post mPost;

    /**
     * The request builder for this PostReply
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BasePostReplyRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options, final Post post) {
        super(requestUrl, client, options);
        mPost = post;
    }

    /**
     * Creates the IPostReplyRequest
     *
     * @return The IPostReplyRequest instance
     */
    public IPostReplyRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IPostReplyRequest with specific options instead of the existing options
     *
     * @param options the options for the request
     * @return The IPostReplyRequest instance
     */
    public IPostReplyRequest buildRequest(final List<Option> options) {
        return new PostReplyRequest(getRequestUrl(), getClient(), options, mPost);
    }
}
